/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.spi.infinispan.impl.embedded;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.RemoteAuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RemoteUserSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.spi.infinispan.impl.embedded.ClientSessionKeyGrouper;

public final class CacheConfigurator {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private static final String MAX_COUNT_SUFFIX = "MaxCount";
    private static final String OWNER_SUFFIX = "Owners";
    private static final int STATE_TRANSFER_CHUNK_SIZE = 16;
    private static final int MIN_NUM_OWNERS_REMOTE_CACHE = 2;

    private CacheConfigurator() {
    }

    public static void configureLocalCaches(Config.Scope keycloakConfig, ConfigurationBuilderHolder holder) {
        logger.debug((Object)"Configuring embedded local caches");
        CacheConfigurator.configureCacheMaxCount(keycloakConfig, holder, Arrays.stream(InfinispanConnectionProvider.LOCAL_MAX_COUNT_CACHES));
        CacheConfigurator.configureRevisionCache(holder, "realms", "realmRevisions", 20000L);
        CacheConfigurator.configureRevisionCache(holder, "users", "userRevisions", 100000L);
        CacheConfigurator.configureRevisionCache(holder, "authorization", "authorizationRevisions", 20000L);
        CacheConfigurator.checkCachesExist(holder, Arrays.stream(InfinispanConnectionProvider.LOCAL_CACHE_NAMES));
    }

    public static void applyDefaultConfiguration(ConfigurationBuilderHolder holder, boolean warnMutate) {
        Map configs = holder.getNamedConfigurationBuilders();
        boolean userProvidedConfig = false;
        boolean clustered = CacheConfigurator.isClustered(holder);
        for (String name : InfinispanConnectionProvider.ALL_CACHES_NAME) {
            ConfigurationBuilder config = (ConfigurationBuilder)configs.get(name);
            if (config == null) {
                configs.put(name, CacheConfigurator.getCacheConfiguration(name, clustered));
                continue;
            }
            if (userProvidedConfig) continue;
            userProvidedConfig = true;
        }
        if (warnMutate && userProvidedConfig) {
            logger.warnf("Modifying the default cache configuration in the config file without setting %s=true is deprecated.", (Object)"cache-config-mutate");
        }
    }

    public static void checkCachesExist(ConfigurationBuilderHolder holder, Stream<String> caches) {
        Iterator it = caches.iterator();
        while (it.hasNext()) {
            String cache = (String)it.next();
            ConfigurationBuilder builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(cache);
            if (builder != null) continue;
            throw CacheConfigurator.cacheNotFound(cache);
        }
    }

    public static void validateWorkCacheConfiguration(ConfigurationBuilderHolder holder) {
        logger.debugf("Validating %s cache configuration", (Object)"work");
        ConfigurationBuilder cacheBuilder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get("work");
        if (cacheBuilder == null) {
            throw CacheConfigurator.cacheNotFound("work");
        }
        if (!CacheConfigurator.isClustered(holder)) {
            return;
        }
        CacheMode cacheMode = cacheBuilder.clustering().cacheMode();
        if (!cacheMode.isReplicated()) {
            throw new RuntimeException("Unable to start Keycloak. '%s' cache must be replicated but is %s".formatted("work", cacheMode.friendlyCacheModeString().toLowerCase()));
        }
    }

    public static void removeClusteredCaches(ConfigurationBuilderHolder holder) {
        logger.debug((Object)"Removing clustered caches");
        Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES).forEach(holder.getNamedConfigurationBuilders()::remove);
    }

    public static void configureCacheMaxCount(Config.Scope keycloakConfig, ConfigurationBuilderHolder holder, Stream<String> caches) {
        Iterator it = caches.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ConfigurationBuilder builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(name);
            if (builder == null) {
                throw CacheConfigurator.cacheNotFound(name);
            }
            Long maxCount = keycloakConfig.getLong(CacheConfigurator.maxCountConfigKey(name));
            if (maxCount == null) continue;
            if (maxCount < 0L) {
                maxCount = builder.memory().maxCount();
                if (maxCount > -1L) {
                    logger.infof("Ignoring unbounded max-count for cache '%s', reverting to default max of %d entries.", (Object)name, (Object)maxCount);
                }
            } else {
                logger.debugf("Overwriting max-count for cache '%s' to %s entries", (Object)name, (Object)maxCount);
            }
            builder.memory().maxCount(maxCount.longValue());
        }
    }

    public static void configureSessionsCachesForPersistentSessions(Config.Scope keycloakConfig, ConfigurationBuilderHolder holder) {
        logger.debug((Object)"Configuring session cache (persistent user sessions)");
        Set<String> sessionCaches = Set.of("sessions", "clientSessions", "offlineSessions", "offlineClientSessions");
        for (String name : InfinispanConnectionProvider.CLUSTERED_MAX_COUNT_CACHES) {
            ConfigurationBuilder builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(name);
            if (builder == null) {
                throw CacheConfigurator.cacheNotFound(name);
            }
            CacheConfigurator.setMemoryMaxCount(keycloakConfig, name, builder);
            if (builder.memory().maxCount() == -1L) {
                logger.infof("Persistent user sessions enabled and no memory limit found in configuration. Setting max entries for %s to %d entries.", (Object)name, (Object)10000);
                builder.memory().maxCount(10000L);
            }
            builder.clustering().hash().numOwners(1);
            if (!sessionCaches.contains(name)) continue;
            CacheConfigurator.configureSessionExpirationReaper(builder);
            builder.clustering().stateTransfer().fetchInMemoryState(false);
        }
    }

    public static void configureSessionsCachesForVolatileSessions(Config.Scope keycloakConfig, ConfigurationBuilderHolder holder) {
        ConfigurationBuilder builder;
        logger.debug((Object)"Configuring session cache (volatile user sessions)");
        for (String name : Arrays.asList("sessions", "clientSessions")) {
            builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(name);
            if (builder == null) {
                throw CacheConfigurator.cacheNotFound(name);
            }
            CacheConfigurator.setMemoryMaxCount(keycloakConfig, name, builder);
            if (builder.memory().maxCount() != -1L) {
                logger.infof("Persistent user sessions disabled and memory limit is set. Ignoring cache limits to avoid losing sessions for cache %s.", (Object)name);
                builder.memory().maxCount(-1L);
            }
            if ((Integer)builder.clustering().hash().attributes().attribute(HashConfiguration.NUM_OWNERS).get() == 1 && builder.persistence().stores().stream().noneMatch(p -> (Boolean)p.attributes().attribute(AbstractStoreConfiguration.SHARED).get())) {
                logger.infof("Persistent user sessions disabled with number of owners set to default value 1 for cache %s and no shared persistence store configured. Setting num_owners=2 to avoid data loss.", (Object)name);
                builder.clustering().hash().numOwners(2);
            }
            CacheConfigurator.configureSessionExpirationReaper(builder);
        }
        for (String name : Arrays.asList("offlineSessions", "offlineClientSessions")) {
            builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(name);
            if (builder == null) {
                throw CacheConfigurator.cacheNotFound(name);
            }
            CacheConfigurator.setMemoryMaxCount(keycloakConfig, name, builder);
            if (builder.memory().maxCount() == -1L) {
                logger.infof("Offline sessions should have a max count set to avoid excessive memory usage. Setting a default cache limit of %d for cache %s.", (Object)10000, (Object)name);
                builder.memory().maxCount(10000L);
            }
            if ((Integer)builder.clustering().hash().attributes().attribute(HashConfiguration.NUM_OWNERS).get() != 1 && builder.persistence().stores().stream().noneMatch(p -> (Boolean)p.attributes().attribute(AbstractStoreConfiguration.SHARED).get())) {
                logger.infof("Setting a memory limit implies to have exactly one owner. Setting num_owners=1 to avoid data loss.", (Object)name);
                builder.clustering().hash().numOwners(1);
            }
            CacheConfigurator.configureSessionExpirationReaper(builder);
            builder.clustering().stateTransfer().fetchInMemoryState(false);
        }
    }

    public static void ensureMinimumOwners(ConfigurationBuilderHolder holder) {
        for (String name : Arrays.asList("loginFailures", "authenticationSessions", "actionTokens")) {
            ConfigurationBuilder builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(name);
            if (builder == null) {
                throw CacheConfigurator.cacheNotFound(name);
            }
            HashConfigurationBuilder hashConfig = builder.clustering().hash();
            Integer owners = (Integer)hashConfig.attributes().attribute(HashConfiguration.NUM_OWNERS).get();
            if (owners >= 2) continue;
            logger.infof("Setting num_owners=2 (configured value is %s) for cache '%s' to prevent data loss.", (Object)owners, (Object)name);
            hashConfig.numOwners(2);
        }
    }

    public static void configureNumOwners(Config.Scope keycloakConfig, ConfigurationBuilderHolder holder) {
        for (String name : InfinispanConnectionProvider.CLUSTERED_CACHE_NUM_OWNERS) {
            ConfigurationBuilder builder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(name);
            if (builder == null) {
                throw CacheConfigurator.cacheNotFound(name);
            }
            Integer owners = keycloakConfig.getInt(CacheConfigurator.numOwnerConfigKey(name));
            if (owners == null) continue;
            builder.clustering().hash().numOwners(owners.intValue());
        }
    }

    public static ConfigurationBuilder getRemoteCacheConfiguration(String cacheName, Config.Scope config, String[] sites) {
        return switch (cacheName) {
            case "clientSessions", "offlineClientSessions" -> CacheConfigurator.remoteCacheConfigurationBuilder(cacheName, config, sites, RemoteAuthenticatedClientSessionEntity.class, InfinispanUserSessionProviderFactory.getExpirationPeriod(TimeUnit.MILLISECONDS));
            case "sessions", "offlineSessions" -> CacheConfigurator.remoteCacheConfigurationBuilder(cacheName, config, sites, RemoteUserSessionEntity.class, InfinispanUserSessionProviderFactory.getExpirationPeriod(TimeUnit.MILLISECONDS));
            case "authenticationSessions" -> CacheConfigurator.remoteCacheConfigurationBuilder(cacheName, config, sites, RootAuthenticationSessionEntity.class, (Long)ExpirationConfiguration.WAKEUP_INTERVAL.getDefaultValue());
            case "loginFailures" -> CacheConfigurator.remoteCacheConfigurationBuilder(cacheName, config, sites, LoginFailureEntity.class, (Long)ExpirationConfiguration.WAKEUP_INTERVAL.getDefaultValue());
            case "actionTokens", "work" -> CacheConfigurator.remoteCacheConfigurationBuilder(cacheName, config, sites, null, (Long)ExpirationConfiguration.WAKEUP_INTERVAL.getDefaultValue());
            default -> null;
        };
    }

    private static void configureSessionExpirationReaper(ConfigurationBuilder builder) {
        builder.expiration().enableReaper().wakeUpInterval(InfinispanUserSessionProviderFactory.getExpirationPeriod(TimeUnit.MILLISECONDS));
    }

    private static ConfigurationBuilder remoteCacheConfigurationBuilder(String name, Config.Scope config, String[] sites, Class<?> indexedEntity, long expirationWakeupPeriodMillis) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.clustering().hash().numOwners(Math.max(2, config.getInt(CacheConfigurator.numOwnerConfigKey(name), Integer.valueOf(2))));
        builder.clustering().stateTransfer().chunkSize(16);
        builder.encoding().mediaType(MediaType.APPLICATION_PROTOSTREAM);
        builder.statistics().enable();
        builder.expiration().enableReaper().wakeUpInterval(expirationWakeupPeriodMillis);
        if (indexedEntity != null) {
            builder.indexing().enable().addIndexedEntities(new String[]{Marshalling.protoEntity(indexedEntity)});
        }
        if (sites == null || sites.length == 0) {
            return builder;
        }
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).useSynchronization(false).lockingMode(LockingMode.PESSIMISTIC);
        for (String site : sites) {
            builder.sites().addBackup().site(site).strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.FAIL).stateTransfer().chunkSize(16);
        }
        return builder;
    }

    private static void configureRevisionCache(ConfigurationBuilderHolder holder, String baseCache, String revisionCache, long defaultMaxEntries) {
        ConfigurationBuilder baseBuilder = (ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(baseCache);
        if (baseBuilder == null) {
            throw CacheConfigurator.cacheNotFound(baseCache);
        }
        long maxCount = baseBuilder.memory().maxCount();
        maxCount = maxCount > 0L ? 2L * maxCount : defaultMaxEntries;
        logger.debugf("Creating revision cache '%s' with max-count %s", (Object)revisionCache, (Object)maxCount);
        holder.getNamedConfigurationBuilders().put(revisionCache, CacheConfigurator.getRevisionCacheConfig(maxCount));
    }

    private static void setMemoryMaxCount(Config.Scope keycloakConfig, String name, ConfigurationBuilder builder) {
        Long maxCount = keycloakConfig.getLong(CacheConfigurator.maxCountConfigKey(name));
        if (maxCount != null) {
            builder.memory().maxCount(maxCount.longValue());
        }
    }

    public static String maxCountConfigKey(String name) {
        return name + MAX_COUNT_SUFFIX;
    }

    public static String numOwnerConfigKey(String name) {
        return name + OWNER_SUFFIX;
    }

    private static IllegalStateException cacheNotFound(String cache) {
        return new IllegalStateException("Infinispan cache '%s' not found.".formatted(cache));
    }

    public static ConfigurationBuilder getCrlCacheConfig() {
        return CacheConfigurator.getCacheConfiguration("crl", true);
    }

    public static ConfigurationBuilder getRevisionCacheConfig(long maxEntries) {
        ConfigurationBuilder builder = CacheConfigurator.createCacheConfigurationBuilder();
        builder.simpleCache(false);
        builder.invocationBatching().enable().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        if (builder.memory().storage().canStoreReferences()) {
            builder.encoding().mediaType("application/x-java-object");
        }
        builder.memory().whenFull(EvictionStrategy.REMOVE).maxCount(maxEntries);
        return builder;
    }

    public static ConfigurationBuilder createCacheConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().mediaType("application/x-java-object");
        builder.simpleCache(true);
        return builder;
    }

    public static ConfigurationBuilder getCacheConfiguration(String cacheName, boolean clustered) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        switch (cacheName) {
            case "clientSessions": 
            case "offlineClientSessions": {
                if (clustered) {
                    builder.clustering().hash().groups().enabled().addGrouper((Grouper)ClientSessionKeyGrouper.INSTANCE);
                }
            }
            case "sessions": 
            case "offlineSessions": {
                if (clustered) {
                    builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(1);
                }
                builder.memory().maxCount(10000L);
                return builder;
            }
            case "actionTokens": 
            case "authenticationSessions": 
            case "loginFailures": {
                if (clustered) {
                    builder.clustering().cacheMode(CacheMode.DIST_SYNC);
                }
                builder.encoding().mediaType("application/x-java-object");
                return builder;
            }
            case "crl": {
                builder.simpleCache(true);
                builder.memory().whenFull(EvictionStrategy.REMOVE).maxCount(1000L);
                return builder;
            }
            case "keys": {
                builder.simpleCache(true);
                builder.expiration().maxIdle(3600L, TimeUnit.SECONDS);
                builder.memory().whenFull(EvictionStrategy.REMOVE).maxCount(1000L);
                return builder;
            }
            case "authorization": 
            case "realms": 
            case "users": {
                builder.simpleCache(true);
                builder.memory().whenFull(EvictionStrategy.REMOVE).maxCount(10000L);
                return builder;
            }
            case "work": {
                if (clustered) {
                    builder.clustering().cacheMode(CacheMode.REPL_SYNC);
                }
                return builder;
            }
        }
        return null;
    }

    private static boolean isClustered(ConfigurationBuilderHolder holder) {
        return holder.getGlobalConfigurationBuilder().transport().getTransport() != null;
    }
}

