/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.workflow.WorkflowProvider;
import org.keycloak.models.workflow.WorkflowStepRunnerSuccessEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.timer.ScheduledTask;

final class WorkflowRunnerScheduledTask
implements ScheduledTask {
    private final Logger logger = Logger.getLogger(WorkflowRunnerScheduledTask.class);
    private final KeycloakSessionFactory sessionFactory;

    WorkflowRunnerScheduledTask(KeycloakSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void run(KeycloakSession session) {
        session.realms().getRealmsStream().map(RealmModel::getId).forEach(this::runScheduledTasksOnRealm);
    }

    private void runScheduledTasksOnRealm(String id) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.sessionFactory, session -> {
            try {
                KeycloakContext context = session.getContext();
                RealmModel realm = session.realms().getRealm(id);
                context.setRealm(realm);
                ((WorkflowProvider)session.getProvider(WorkflowProvider.class)).runScheduledSteps();
                this.sessionFactory.publish((ProviderEvent)new WorkflowStepRunnerSuccessEvent(session));
            }
            catch (Exception e) {
                this.logger.errorf((Throwable)e, "Failed to run workflow steps on realm with id '%s'", (Object)id);
            }
        });
    }

    public String getTaskName() {
        return "workflow-runner-task";
    }
}

