/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.json;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonExistsFunction;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class SingleStoreJsonExistsFunction
extends JsonExistsFunction {
    public SingleStoreJsonExistsFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    protected void render(SqlAppender sqlAppender, JsonExistsFunction.JsonExistsArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String jsonPath;
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonExistsErrorBehavior.ERROR) {
            throw new QueryException("Can't emulate on error clause on SingleStore");
        }
        try {
            jsonPath = (String)walker.getLiteralValue(arguments.jsonPath());
        }
        catch (Exception ex) {
            throw new QueryException("SingleStore json_exists only support literal json paths, but got " + String.valueOf(arguments.jsonPath()));
        }
        List jsonPathElements = JsonPathHelper.parseJsonPathElements((String)jsonPath);
        sqlAppender.appendSql("json_match_any_exists(");
        arguments.jsonDocument().accept(walker);
        for (JsonPathHelper.JsonPathElement pathElement : jsonPathElements) {
            sqlAppender.appendSql(',');
            if (pathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)pathElement;
                sqlAppender.appendSingleQuoteEscapedString(attribute.attribute());
                continue;
            }
            if (pathElement instanceof JsonPathHelper.JsonParameterIndexAccess) {
                String parameterName = ((JsonPathHelper.JsonParameterIndexAccess)pathElement).parameterName();
                throw new QueryException("JSON path [" + jsonPath + "] uses parameter [" + parameterName + "] that is not passed");
            }
            sqlAppender.appendSql('\'');
            sqlAppender.appendSql(((JsonPathHelper.JsonIndexAccess)pathElement).index());
            sqlAppender.appendSql('\'');
        }
        sqlAppender.appendSql(')');
    }
}

