/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.workload.PayloadGenerator;

public class TimestampConstantPayloadGenerator
implements PayloadGenerator {
    private final int size;
    private final ByteBuffer buffer;

    @JsonCreator
    public TimestampConstantPayloadGenerator(@JsonProperty(value="size") int size) {
        this.size = size;
        if (size < 8) {
            throw new RuntimeException("The size of the payload must be greater than or equal to 8.");
        }
        this.buffer = ByteBuffer.allocate(8);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @JsonProperty
    public int size() {
        return this.size;
    }

    @Override
    public synchronized byte[] generate(long position) {
        byte[] result = new byte[this.size];
        this.buffer.clear();
        this.buffer.putLong(Time.SYSTEM.milliseconds());
        this.buffer.rewind();
        System.arraycopy(this.buffer.array(), 0, result, 0, 8);
        return result;
    }
}

