/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Set;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.graph.StateStoreNode;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.StoreDelegatingProcessorSupplier;
import org.apache.kafka.streams.processor.internals.StoreFactory;

public class GlobalStoreNode<KIn, VIn, S extends StateStore>
extends StateStoreNode<S> {
    private final String sourceName;
    private final String topic;
    private final ConsumedInternal<KIn, VIn> consumed;
    private final String processorName;
    private final ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier;
    private final boolean reprocessOnRestore;

    public GlobalStoreNode(StoreFactory storeBuilder, String sourceName, String topic, ConsumedInternal<KIn, VIn> consumed, String processorName, ProcessorSupplier<KIn, VIn, Void, Void> stateUpdateSupplier, boolean reprocessOnRestore) {
        super(storeBuilder);
        this.sourceName = sourceName;
        this.topic = topic;
        this.consumed = consumed;
        this.processorName = processorName;
        this.stateUpdateSupplier = stateUpdateSupplier;
        this.reprocessOnRestore = reprocessOnRestore;
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        this.storeBuilder.withLoggingDisabled();
        topologyBuilder.addGlobalStore(this.sourceName, this.consumed.timestampExtractor(), this.consumed.keyDeserializer(), this.consumed.valueDeserializer(), this.topic, this.processorName, new StoreDelegatingProcessorSupplier<KIn, VIn, Void, Void>(this.stateUpdateSupplier, Set.of(new StoreFactory.FactoryWrappingStoreBuilder(this.storeBuilder))), this.reprocessOnRestore);
    }

    @Override
    public String toString() {
        return "GlobalStoreNode{sourceName='" + this.sourceName + "', topic='" + this.topic + "', processorName='" + this.processorName + "', reprocessOnRestore='" + this.reprocessOnRestore + "'} ";
    }
}

