/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import javajs.api.GenericZipTools;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.ZipTools;

public class ZipData {
    boolean isEnabled = true;
    byte[] buf;
    int pt;
    int nBytes;

    public ZipData(int nBytes) {
        this.nBytes = nBytes;
    }

    public int addBytes(byte[] byteBuf, int nSectorBytes, int nBytesRemaining) {
        if (this.pt == 0) {
            if (!Rdr.isGzipB(byteBuf)) {
                this.isEnabled = false;
                return -1;
            }
            this.buf = new byte[nBytesRemaining];
        }
        int nToAdd = Math.min(nSectorBytes, nBytesRemaining);
        System.arraycopy(byteBuf, 0, this.buf, this.pt, nToAdd);
        this.pt += nToAdd;
        return nBytesRemaining - nToAdd;
    }

    public void addTo(GenericZipTools jzt, SB data) {
        data.append(ZipData.getGzippedBytesAsString(jzt, this.buf));
    }

    static String getGzippedBytesAsString(GenericZipTools jzt, byte[] bytes) {
        try {
            BufferedInputStream bis = jzt.getUnGzippedInputStream(bytes);
            String s = ZipTools.getStreamAsString(bis);
            bis.close();
            return s;
        }
        catch (Exception e) {
            return "";
        }
    }
}

