/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.properties;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.internal.Cast;
import org.jspecify.annotations.Nullable;

public class FilteringGradleProperties
implements GradleProperties {
    private final GradleProperties delegate;
    private final Predicate<String> propertyNameFilter;

    public FilteringGradleProperties(GradleProperties delegate, SerializableLambdas.SerializablePredicate<String> propertyNameFilter) {
        this.delegate = delegate;
        this.propertyNameFilter = propertyNameFilter;
    }

    public @Nullable Object findUnsafe(String propertyName) {
        if (!this.propertyNameFilter.test(propertyName)) {
            return null;
        }
        return this.delegate.findUnsafe(propertyName);
    }

    public @Nullable String find(String propertyName) {
        return (String)Cast.uncheckedCast((Object)this.findUnsafe(propertyName));
    }

    public Map<String, String> getProperties() {
        return this.collectProperties(this.propertyNameFilter);
    }

    public Map<String, String> getPropertiesWithPrefix(String prefix) {
        return this.collectProperties(it -> it.startsWith(prefix) && this.propertyNameFilter.test((String)it));
    }

    private ImmutableMap<String, String> collectProperties(Predicate<String> keyFilter) {
        return (ImmutableMap)this.delegate.getProperties().entrySet().stream().filter(it -> keyFilter.test((String)it.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

