/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDCursor;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.data.AbstractDataEditor;

public class CursorViewComposite
extends Composite
implements IResultSetContainer {
    private static final Log log = Log.getLog(CursorViewComposite.class);
    private IValueController valueController;
    private DBDCursor value;
    private ResultSetViewer resultSetViewer;
    private CursorDataContainer dataContainer;
    private boolean fetched;

    public CursorViewComposite(Composite parent, IValueController valueController) {
        super(parent, 0);
        DBPPreferenceStore preferenceStore;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.valueController = valueController;
        this.dataContainer = new CursorDataContainer();
        this.value = (DBDCursor)valueController.getValue();
        if (this.value != null && !(preferenceStore = valueController.getExecutionContext().getDataSource().getContainer().getPreferenceStore()).getBoolean("keep.statement.open") && ConfirmationDialog.confirmAction((Shell)this.getShell(), (String)"keep_statement_open", (int)3, (Object[])new Object[0]) == 2) {
            IResultSetController rsv;
            preferenceStore.setValue("keep.statement.open", true);
            if (valueController.getValueSite().getPart() instanceof IResultSetContainer && (rsv = ((IResultSetContainer)valueController.getValueSite().getPart()).getResultSetController()) != null) {
                rsv.refresh();
            }
        }
        this.resultSetViewer = new ResultSetViewer(this, valueController.getValueSite(), this);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.grabExcessVerticalSpace = true;
        this.resultSetViewer.getControl().setLayoutData((Object)gd);
    }

    public void setValue(DBDCursor value) {
        if (this.value != value) {
            this.fetched = false;
            this.value = value;
        }
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null) {
            return executionContext.getDataSource().getContainer().getProject();
        }
        return null;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.valueController == null ? null : this.valueController.getExecutionContext();
    }

    @Override
    @Nullable
    public ResultSetViewer getResultSetController() {
        return this.resultSetViewer;
    }

    @Override
    @Nullable
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public boolean isReadyToRun() {
        return true;
    }

    @Override
    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            return;
        }
        DBNDatabaseNode targetNode = dataContainer.getDataSource().getContainer().getProject().getNavigatorModel().getNodeByObject(monitor, (DBSObject)dataContainer, false);
        if (targetNode == null) {
            UIUtils.showMessageBox(null, (String)"Open link", (String)("Cannot navigate to '" + DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' - navigator node not found"), (int)1);
            return;
        }
        AbstractDataEditor.openNewDataEditor(targetNode, newFilter);
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        return new QueryResultsDecorator(){

            @Override
            public long getDecoratorFeatures() {
                return CursorViewComposite.this.valueController.getEditType() == IValueController.EditType.EDITOR ? 54L : 16L;
            }
        };
    }

    public Control getControl() {
        return this.resultSetViewer == null ? null : this.resultSetViewer.getControl();
    }

    public void refresh() {
        if (!this.fetched) {
            this.resultSetViewer.refresh();
            this.fetched = true;
        }
    }

    public boolean isDirty() {
        return this.resultSetViewer.isDirty();
    }

    private class CursorDataContainer
    implements DBSDataContainer {
        private CursorDataContainer() {
        }

        @NotNull
        public String[] getSupportedFeatures() {
            return new String[]{"data.select"};
        }

        @NotNull
        public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBException {
            DBCResultSet resultSet;
            DBCStatistics statistics = new DBCStatistics();
            DBCResultSet dBCResultSet = resultSet = CursorViewComposite.this.value == null ? null : CursorViewComposite.this.value.openResultSet(session);
            if (resultSet == null) {
                return statistics;
            }
            DBRProgressMonitor monitor = session.getProgressMonitor();
            if (firstRow > 0L) {
                try {
                    resultSet.moveTo((int)firstRow);
                }
                catch (DBCException e) {
                    log.debug((Object)e);
                }
            }
            Throwable throwable = null;
            Object var16_15 = null;
            try {
                try {
                    long rowCount;
                    long startTime = System.currentTimeMillis();
                    dataReceiver.fetchStart(session, resultSet, firstRow, maxRows);
                    try {
                        rowCount = 0L;
                        while (resultSet.nextRow()) {
                            if (monitor.isCanceled()) {
                                break;
                            }
                            dataReceiver.fetchRow(session, resultSet);
                            if (++rowCount >= maxRows) {
                                break;
                            }
                            if (rowCount % 100L != 0L) continue;
                            monitor.subTask(rowCount + ResultSetMessages.dialog_cursor_view_monitor_rows_fetched);
                            monitor.worked(100);
                        }
                    }
                    finally {
                        try {
                            dataReceiver.fetchEnd(session, resultSet);
                        }
                        catch (DBCException e) {
                            log.error((Object)"Error while finishing result set fetch", (Throwable)e);
                        }
                        dataReceiver.close();
                    }
                    statistics.setFetchTime(System.currentTimeMillis() - startTime);
                    statistics.setRowsFetched(rowCount);
                    return statistics;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) {
            return -1L;
        }

        @Nullable
        public String getDescription() {
            return CursorViewComposite.this.value.toString();
        }

        public DBSObject getParentObject() {
            return null;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return CursorViewComposite.this.valueController == null ? null : CursorViewComposite.this.valueController.getExecutionContext().getDataSource();
        }

        @NotNull
        public String getName() {
            return CursorViewComposite.this.value.toString();
        }

        public boolean isPersisted() {
            return false;
        }
    }
}

