/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithm;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

final class ChecksumCalculator {
    private final List<Checksum> checksums = new ArrayList<Checksum>();
    private final File targetFile;

    public static ChecksumCalculator newInstance(File targetFile, Collection<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        if (checksumAlgorithmFactories == null || checksumAlgorithmFactories.isEmpty()) {
            return null;
        }
        return new ChecksumCalculator(targetFile, checksumAlgorithmFactories);
    }

    private ChecksumCalculator(File targetFile, Collection<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        HashSet<String> algos = new HashSet<String>();
        for (ChecksumAlgorithmFactory checksumAlgorithmFactory : checksumAlgorithmFactories) {
            if (!algos.add(checksumAlgorithmFactory.getName())) continue;
            this.checksums.add(new Checksum(checksumAlgorithmFactory));
        }
        this.targetFile = targetFile;
    }

    public void init(long dataOffset) {
        for (Checksum checksum : this.checksums) {
            checksum.reset();
        }
        if (dataOffset <= 0L) {
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.targetFile));
            Object object = null;
            try {
                long total = 0L;
                byte[] buffer2 = new byte[32768];
                while (total < dataOffset) {
                    int read2 = ((InputStream)in).read(buffer2);
                    if (read2 < 0) {
                        throw new IOException(this.targetFile + " contains only " + total + " bytes, cannot resume download from offset " + dataOffset);
                    }
                    if ((total += (long)read2) > dataOffset) {
                        read2 = (int)((long)read2 - (total - dataOffset));
                    }
                    this.update(ByteBuffer.wrap(buffer2, 0, read2));
                }
            }
            catch (Throwable total) {
                object = total;
                throw total;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable total) {
                            ((Throwable)object).addSuppressed(total);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
        }
        catch (IOException e2) {
            for (Checksum checksum : this.checksums) {
                checksum.error(e2);
            }
        }
    }

    public void update(ByteBuffer data2) {
        for (Checksum checksum : this.checksums) {
            ((Buffer)data2).mark();
            checksum.update(data2);
            ((Buffer)data2).reset();
        }
    }

    public Map<String, Object> get() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Checksum checksum : this.checksums) {
            results.put(checksum.checksumAlgorithmFactory.getName(), checksum.get());
        }
        return results;
    }

    static class Checksum {
        final ChecksumAlgorithmFactory checksumAlgorithmFactory;
        ChecksumAlgorithm algorithm;
        Exception error;

        Checksum(ChecksumAlgorithmFactory checksumAlgorithmFactory) {
            this.checksumAlgorithmFactory = Objects.requireNonNull(checksumAlgorithmFactory);
            this.algorithm = checksumAlgorithmFactory.getAlgorithm();
        }

        public void reset() {
            this.algorithm = this.checksumAlgorithmFactory.getAlgorithm();
            this.error = null;
        }

        public void update(ByteBuffer buffer2) {
            this.algorithm.update(buffer2);
        }

        public void error(Exception error2) {
            this.error = error2;
        }

        public Object get() {
            if (this.error != null) {
                return this.error;
            }
            return this.algorithm.checksum();
        }
    }
}

