﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-signals/ApplicationSignals_EXPORTS.h>
#include <aws/application-signals/model/ServiceDependency.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ApplicationSignals {
namespace Model {
class ListServiceDependenciesResult {
 public:
  AWS_APPLICATIONSIGNALS_API ListServiceDependenciesResult() = default;
  AWS_APPLICATIONSIGNALS_API ListServiceDependenciesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPLICATIONSIGNALS_API ListServiceDependenciesResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The start of the time period that the returned information applies to. When
   * used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For
   * example: <code>1698778057</code> </p> <p>This displays the time that Application
   * Signals used for the request. It might not match your request exactly, because
   * it was rounded to the nearest hour.</p>
   */
  inline const Aws::Utils::DateTime& GetStartTime() const { return m_startTime; }
  template <typename StartTimeT = Aws::Utils::DateTime>
  void SetStartTime(StartTimeT&& value) {
    m_startTimeHasBeenSet = true;
    m_startTime = std::forward<StartTimeT>(value);
  }
  template <typename StartTimeT = Aws::Utils::DateTime>
  ListServiceDependenciesResult& WithStartTime(StartTimeT&& value) {
    SetStartTime(std::forward<StartTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The end of the time period that the returned information applies to. When
   * used in a raw HTTP Query API, it is formatted as be epoch time in seconds. For
   * example: <code>1698778057</code> </p> <p>This displays the time that Application
   * Signals used for the request. It might not match your request exactly, because
   * it was rounded to the nearest hour.</p>
   */
  inline const Aws::Utils::DateTime& GetEndTime() const { return m_endTime; }
  template <typename EndTimeT = Aws::Utils::DateTime>
  void SetEndTime(EndTimeT&& value) {
    m_endTimeHasBeenSet = true;
    m_endTime = std::forward<EndTimeT>(value);
  }
  template <typename EndTimeT = Aws::Utils::DateTime>
  ListServiceDependenciesResult& WithEndTime(EndTimeT&& value) {
    SetEndTime(std::forward<EndTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array, where each object in the array contains information about one of
   * the dependencies of this service.</p>
   */
  inline const Aws::Vector<ServiceDependency>& GetServiceDependencies() const { return m_serviceDependencies; }
  template <typename ServiceDependenciesT = Aws::Vector<ServiceDependency>>
  void SetServiceDependencies(ServiceDependenciesT&& value) {
    m_serviceDependenciesHasBeenSet = true;
    m_serviceDependencies = std::forward<ServiceDependenciesT>(value);
  }
  template <typename ServiceDependenciesT = Aws::Vector<ServiceDependency>>
  ListServiceDependenciesResult& WithServiceDependencies(ServiceDependenciesT&& value) {
    SetServiceDependencies(std::forward<ServiceDependenciesT>(value));
    return *this;
  }
  template <typename ServiceDependenciesT = ServiceDependency>
  ListServiceDependenciesResult& AddServiceDependencies(ServiceDependenciesT&& value) {
    m_serviceDependenciesHasBeenSet = true;
    m_serviceDependencies.emplace_back(std::forward<ServiceDependenciesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Include this value in your next use of this API to get next set of service
   * dependencies.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListServiceDependenciesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListServiceDependenciesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_startTime{};

  Aws::Utils::DateTime m_endTime{};

  Aws::Vector<ServiceDependency> m_serviceDependencies;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_startTimeHasBeenSet = false;
  bool m_endTimeHasBeenSet = false;
  bool m_serviceDependenciesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationSignals
}  // namespace Aws
